using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace SPStudio
{
	/// <summary>
	/// Form used to shift the 
	/// four data sets.
	/// </summary>
	public class ShiftForm : System.Windows.Forms.Form
	{
		#region Private Vars
		private Workspace workspace = null;
		#endregion

		#region Windows Generated Vars
		private System.Windows.Forms.Panel Region1Panel;
		private System.Windows.Forms.Panel Region2Panel;
		private System.Windows.Forms.Panel Region3Panel;
		private System.Windows.Forms.Panel Region4Panel;
		private System.Windows.Forms.Label Region1Label;
		private System.Windows.Forms.Label Region2Label;
		private System.Windows.Forms.Label Region3Label;
		private System.Windows.Forms.Label Region4Label;
		private System.Windows.Forms.Button Region1Forward;
		private System.Windows.Forms.Button Region1Backward;
		private System.Windows.Forms.Button Region1Left;
		private System.Windows.Forms.Button Region1Right;
		private System.Windows.Forms.Button Region2Forward;
		private System.Windows.Forms.Button Region2Backward;
		private System.Windows.Forms.Button Region2Left;
		private System.Windows.Forms.Button Region2Right;
		private System.Windows.Forms.Button Region3Forward;
		private System.Windows.Forms.Button Region3Backward;
		private System.Windows.Forms.Button Region3Left;
		private System.Windows.Forms.Button Region3Right;
		private System.Windows.Forms.Button Region4Forward;
		private System.Windows.Forms.Button Region4Backward;
		private System.Windows.Forms.Button Region4Left;
		private System.Windows.Forms.Button Region4Right;
		private System.Windows.Forms.Button FinalizeButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		#region Constructor
		/// <summary>
		/// Construtor assigns a 
		/// handle to the parent workspace.
		/// Initializes MDI parent property.
		/// </summary>
		/// <param name="Parent"></param>
		public ShiftForm(Workspace Parent)
		{
			workspace = Parent;
			InitializeComponent();

			MdiParent = Parent.desktop;
			Show();
		}
		#endregion

		#region Dispose Operation
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Region1Panel = new System.Windows.Forms.Panel();
			this.Region1Right = new System.Windows.Forms.Button();
			this.Region1Left = new System.Windows.Forms.Button();
			this.Region1Backward = new System.Windows.Forms.Button();
			this.Region1Forward = new System.Windows.Forms.Button();
			this.Region1Label = new System.Windows.Forms.Label();
			this.Region2Panel = new System.Windows.Forms.Panel();
			this.Region2Right = new System.Windows.Forms.Button();
			this.Region2Left = new System.Windows.Forms.Button();
			this.Region2Backward = new System.Windows.Forms.Button();
			this.Region2Forward = new System.Windows.Forms.Button();
			this.Region2Label = new System.Windows.Forms.Label();
			this.Region3Panel = new System.Windows.Forms.Panel();
			this.Region3Right = new System.Windows.Forms.Button();
			this.Region3Left = new System.Windows.Forms.Button();
			this.Region3Backward = new System.Windows.Forms.Button();
			this.Region3Forward = new System.Windows.Forms.Button();
			this.Region3Label = new System.Windows.Forms.Label();
			this.Region4Panel = new System.Windows.Forms.Panel();
			this.Region4Right = new System.Windows.Forms.Button();
			this.Region4Left = new System.Windows.Forms.Button();
			this.Region4Backward = new System.Windows.Forms.Button();
			this.Region4Forward = new System.Windows.Forms.Button();
			this.Region4Label = new System.Windows.Forms.Label();
			this.FinalizeButton = new System.Windows.Forms.Button();
			this.Region1Panel.SuspendLayout();
			this.Region2Panel.SuspendLayout();
			this.Region3Panel.SuspendLayout();
			this.Region4Panel.SuspendLayout();
			this.SuspendLayout();
			// 
			// Region1Panel
			// 
			this.Region1Panel.Controls.Add(this.Region1Right);
			this.Region1Panel.Controls.Add(this.Region1Left);
			this.Region1Panel.Controls.Add(this.Region1Backward);
			this.Region1Panel.Controls.Add(this.Region1Forward);
			this.Region1Panel.Controls.Add(this.Region1Label);
			this.Region1Panel.Dock = System.Windows.Forms.DockStyle.Top;
			this.Region1Panel.Location = new System.Drawing.Point(0, 0);
			this.Region1Panel.Name = "Region1Panel";
			this.Region1Panel.Size = new System.Drawing.Size(552, 40);
			this.Region1Panel.TabIndex = 0;
			// 
			// Region1Right
			// 
			this.Region1Right.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region1Right.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region1Right.Location = new System.Drawing.Point(432, 0);
			this.Region1Right.Name = "Region1Right";
			this.Region1Right.Size = new System.Drawing.Size(120, 40);
			this.Region1Right.TabIndex = 4;
			this.Region1Right.Text = "Right";
			this.Region1Right.Click += new System.EventHandler(this.Region1Right_Click);
			// 
			// Region1Left
			// 
			this.Region1Left.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region1Left.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region1Left.Location = new System.Drawing.Point(320, 0);
			this.Region1Left.Name = "Region1Left";
			this.Region1Left.Size = new System.Drawing.Size(112, 40);
			this.Region1Left.TabIndex = 3;
			this.Region1Left.Text = "Left";
			this.Region1Left.Click += new System.EventHandler(this.Region1Left_Click);
			// 
			// Region1Backward
			// 
			this.Region1Backward.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region1Backward.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region1Backward.Location = new System.Drawing.Point(208, 0);
			this.Region1Backward.Name = "Region1Backward";
			this.Region1Backward.Size = new System.Drawing.Size(112, 40);
			this.Region1Backward.TabIndex = 2;
			this.Region1Backward.Text = "Backward";
			this.Region1Backward.Click += new System.EventHandler(this.Region1Backward_Click);
			// 
			// Region1Forward
			// 
			this.Region1Forward.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region1Forward.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region1Forward.Location = new System.Drawing.Point(96, 0);
			this.Region1Forward.Name = "Region1Forward";
			this.Region1Forward.Size = new System.Drawing.Size(112, 40);
			this.Region1Forward.TabIndex = 1;
			this.Region1Forward.Text = "Forward";
			this.Region1Forward.Click += new System.EventHandler(this.Region1Forward_Click);
			// 
			// Region1Label
			// 
			this.Region1Label.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.Region1Label.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region1Label.Location = new System.Drawing.Point(0, 0);
			this.Region1Label.Name = "Region1Label";
			this.Region1Label.Size = new System.Drawing.Size(96, 40);
			this.Region1Label.TabIndex = 0;
			this.Region1Label.Text = "Region 1 (red)";
			this.Region1Label.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// Region2Panel
			// 
			this.Region2Panel.Controls.Add(this.Region2Right);
			this.Region2Panel.Controls.Add(this.Region2Left);
			this.Region2Panel.Controls.Add(this.Region2Backward);
			this.Region2Panel.Controls.Add(this.Region2Forward);
			this.Region2Panel.Controls.Add(this.Region2Label);
			this.Region2Panel.Dock = System.Windows.Forms.DockStyle.Top;
			this.Region2Panel.Location = new System.Drawing.Point(0, 40);
			this.Region2Panel.Name = "Region2Panel";
			this.Region2Panel.Size = new System.Drawing.Size(552, 40);
			this.Region2Panel.TabIndex = 1;
			// 
			// Region2Right
			// 
			this.Region2Right.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region2Right.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region2Right.Location = new System.Drawing.Point(432, 0);
			this.Region2Right.Name = "Region2Right";
			this.Region2Right.Size = new System.Drawing.Size(120, 40);
			this.Region2Right.TabIndex = 4;
			this.Region2Right.Text = "Right";
			this.Region2Right.Click += new System.EventHandler(this.Region2Right_Click);
			// 
			// Region2Left
			// 
			this.Region2Left.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region2Left.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region2Left.Location = new System.Drawing.Point(320, 0);
			this.Region2Left.Name = "Region2Left";
			this.Region2Left.Size = new System.Drawing.Size(112, 40);
			this.Region2Left.TabIndex = 3;
			this.Region2Left.Text = "Left";
			this.Region2Left.Click += new System.EventHandler(this.Region2Left_Click);
			// 
			// Region2Backward
			// 
			this.Region2Backward.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region2Backward.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region2Backward.Location = new System.Drawing.Point(208, 0);
			this.Region2Backward.Name = "Region2Backward";
			this.Region2Backward.Size = new System.Drawing.Size(112, 40);
			this.Region2Backward.TabIndex = 2;
			this.Region2Backward.Text = "Backward";
			this.Region2Backward.Click += new System.EventHandler(this.Region2Backward_Click);
			// 
			// Region2Forward
			// 
			this.Region2Forward.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region2Forward.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region2Forward.Location = new System.Drawing.Point(96, 0);
			this.Region2Forward.Name = "Region2Forward";
			this.Region2Forward.Size = new System.Drawing.Size(112, 40);
			this.Region2Forward.TabIndex = 1;
			this.Region2Forward.Text = "Forward";
			this.Region2Forward.Click += new System.EventHandler(this.Region2Forward_Click);
			// 
			// Region2Label
			// 
			this.Region2Label.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.Region2Label.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region2Label.Location = new System.Drawing.Point(0, 0);
			this.Region2Label.Name = "Region2Label";
			this.Region2Label.Size = new System.Drawing.Size(96, 40);
			this.Region2Label.TabIndex = 0;
			this.Region2Label.Text = "Region 2 (green)";
			this.Region2Label.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// Region3Panel
			// 
			this.Region3Panel.Controls.Add(this.Region3Right);
			this.Region3Panel.Controls.Add(this.Region3Left);
			this.Region3Panel.Controls.Add(this.Region3Backward);
			this.Region3Panel.Controls.Add(this.Region3Forward);
			this.Region3Panel.Controls.Add(this.Region3Label);
			this.Region3Panel.Dock = System.Windows.Forms.DockStyle.Top;
			this.Region3Panel.Location = new System.Drawing.Point(0, 80);
			this.Region3Panel.Name = "Region3Panel";
			this.Region3Panel.Size = new System.Drawing.Size(552, 40);
			this.Region3Panel.TabIndex = 2;
			// 
			// Region3Right
			// 
			this.Region3Right.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region3Right.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region3Right.Location = new System.Drawing.Point(432, 0);
			this.Region3Right.Name = "Region3Right";
			this.Region3Right.Size = new System.Drawing.Size(120, 40);
			this.Region3Right.TabIndex = 4;
			this.Region3Right.Text = "Right";
			this.Region3Right.Click += new System.EventHandler(this.Region3Right_Click);
			// 
			// Region3Left
			// 
			this.Region3Left.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region3Left.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region3Left.Location = new System.Drawing.Point(320, 0);
			this.Region3Left.Name = "Region3Left";
			this.Region3Left.Size = new System.Drawing.Size(112, 40);
			this.Region3Left.TabIndex = 3;
			this.Region3Left.Text = "Left";
			this.Region3Left.Click += new System.EventHandler(this.Region3Left_Click);
			// 
			// Region3Backward
			// 
			this.Region3Backward.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region3Backward.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region3Backward.Location = new System.Drawing.Point(208, 0);
			this.Region3Backward.Name = "Region3Backward";
			this.Region3Backward.Size = new System.Drawing.Size(112, 40);
			this.Region3Backward.TabIndex = 2;
			this.Region3Backward.Text = "Backward";
			this.Region3Backward.Click += new System.EventHandler(this.Region3Backward_Click);
			// 
			// Region3Forward
			// 
			this.Region3Forward.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region3Forward.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region3Forward.Location = new System.Drawing.Point(96, 0);
			this.Region3Forward.Name = "Region3Forward";
			this.Region3Forward.Size = new System.Drawing.Size(112, 40);
			this.Region3Forward.TabIndex = 1;
			this.Region3Forward.Text = "Forward";
			this.Region3Forward.Click += new System.EventHandler(this.Region3Forward_Click);
			// 
			// Region3Label
			// 
			this.Region3Label.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.Region3Label.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region3Label.Location = new System.Drawing.Point(0, 0);
			this.Region3Label.Name = "Region3Label";
			this.Region3Label.Size = new System.Drawing.Size(96, 40);
			this.Region3Label.TabIndex = 0;
			this.Region3Label.Text = "Region 3 (white)";
			this.Region3Label.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// Region4Panel
			// 
			this.Region4Panel.Controls.Add(this.Region4Right);
			this.Region4Panel.Controls.Add(this.Region4Left);
			this.Region4Panel.Controls.Add(this.Region4Backward);
			this.Region4Panel.Controls.Add(this.Region4Forward);
			this.Region4Panel.Controls.Add(this.Region4Label);
			this.Region4Panel.Dock = System.Windows.Forms.DockStyle.Top;
			this.Region4Panel.Location = new System.Drawing.Point(0, 120);
			this.Region4Panel.Name = "Region4Panel";
			this.Region4Panel.Size = new System.Drawing.Size(552, 40);
			this.Region4Panel.TabIndex = 3;
			// 
			// Region4Right
			// 
			this.Region4Right.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region4Right.Location = new System.Drawing.Point(432, 0);
			this.Region4Right.Name = "Region4Right";
			this.Region4Right.Size = new System.Drawing.Size(120, 40);
			this.Region4Right.TabIndex = 4;
			this.Region4Right.Text = "Right";
			this.Region4Right.Click += new System.EventHandler(this.Region4Right_Click);
			// 
			// Region4Left
			// 
			this.Region4Left.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region4Left.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region4Left.Location = new System.Drawing.Point(320, 0);
			this.Region4Left.Name = "Region4Left";
			this.Region4Left.Size = new System.Drawing.Size(112, 40);
			this.Region4Left.TabIndex = 3;
			this.Region4Left.Text = "Left";
			this.Region4Left.Click += new System.EventHandler(this.Region4Left_Click);
			// 
			// Region4Backward
			// 
			this.Region4Backward.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region4Backward.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region4Backward.Location = new System.Drawing.Point(208, 0);
			this.Region4Backward.Name = "Region4Backward";
			this.Region4Backward.Size = new System.Drawing.Size(112, 40);
			this.Region4Backward.TabIndex = 2;
			this.Region4Backward.Text = "Backward";
			this.Region4Backward.Click += new System.EventHandler(this.Region4Backward_Click);
			// 
			// Region4Forward
			// 
			this.Region4Forward.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region4Forward.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.Region4Forward.Location = new System.Drawing.Point(96, 0);
			this.Region4Forward.Name = "Region4Forward";
			this.Region4Forward.Size = new System.Drawing.Size(112, 40);
			this.Region4Forward.TabIndex = 1;
			this.Region4Forward.Text = "Forward";
			this.Region4Forward.Click += new System.EventHandler(this.Region4Forward_Click);
			// 
			// Region4Label
			// 
			this.Region4Label.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.Region4Label.Dock = System.Windows.Forms.DockStyle.Left;
			this.Region4Label.Location = new System.Drawing.Point(0, 0);
			this.Region4Label.Name = "Region4Label";
			this.Region4Label.Size = new System.Drawing.Size(96, 40);
			this.Region4Label.TabIndex = 0;
			this.Region4Label.Text = "Region 4 (blue)";
			this.Region4Label.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// FinalizeButton
			// 
			this.FinalizeButton.Dock = System.Windows.Forms.DockStyle.Top;
			this.FinalizeButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.FinalizeButton.Location = new System.Drawing.Point(0, 160);
			this.FinalizeButton.Name = "FinalizeButton";
			this.FinalizeButton.Size = new System.Drawing.Size(552, 32);
			this.FinalizeButton.TabIndex = 4;
			this.FinalizeButton.Text = "FINALIZE";
			this.FinalizeButton.Click += new System.EventHandler(this.FinalizeButton_Click);
			// 
			// ShiftForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(552, 188);
			this.Controls.Add(this.FinalizeButton);
			this.Controls.Add(this.Region4Panel);
			this.Controls.Add(this.Region3Panel);
			this.Controls.Add(this.Region2Panel);
			this.Controls.Add(this.Region1Panel);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D;
			this.MaximizeBox = false;
			this.Name = "ShiftForm";
			this.Text = "Shift";
			this.Region1Panel.ResumeLayout(false);
			this.Region2Panel.ResumeLayout(false);
			this.Region3Panel.ResumeLayout(false);
			this.Region4Panel.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Shift Button Handling
		/// <summary>
		/// Shift the Region1 voxels right.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region1Right_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=workspace.vectorCols-1; xIndex>=0; xIndex--)
					{
						if(xIndex==0)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in0to90 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in0to90 = workspace.vectors[xIndex-1,yIndex,zIndex].in0to90;
						}
					}
			workspace.refreshShiftView();				
		}

		/// <summary>
		/// Shift the Region1 voxels left.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region1Left_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(xIndex==workspace.vectorCols-1)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in0to90 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in0to90 = workspace.vectors[xIndex+1,yIndex,zIndex].in0to90;
						}
					}
			workspace.refreshShiftView();		
		}

		/// <summary>
		/// Shift the Region1 voxels backward.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region1Backward_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(zIndex==workspace.vectorCols-1)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in0to90 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in0to90 = workspace.vectors[xIndex,yIndex,zIndex+1].in0to90;
						}
					}
			workspace.refreshShiftView();		
		}

		/// <summary>
		/// Shift the Region1 voxels forward.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region1Forward_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=workspace.vectorCols-1; zIndex>=0; zIndex--)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(zIndex==0)
							workspace.vectors[xIndex,yIndex,zIndex].in0to90 = false;
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in0to90 = workspace.vectors[xIndex,yIndex,zIndex-1].in0to90;
						}
					}
			workspace.refreshShiftView();			
		}

		/// <summary>
		/// Shift the Region2 voxels right.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region2Right_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=workspace.vectorCols-1; xIndex>=0; xIndex--)
					{
						if(xIndex==0)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in90to180 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in90to180 = workspace.vectors[xIndex-1,yIndex,zIndex].in90to180;
						}
					}
			workspace.refreshShiftView();						
		}

		/// <summary>
		/// Shift the Region2 voxels left.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region2Left_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(xIndex==workspace.vectorCols-1)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in90to180 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in90to180 = workspace.vectors[xIndex+1,yIndex,zIndex].in90to180;
						}
					}
			workspace.refreshShiftView();		
		}

		/// <summary>
		/// Shift the Region2 voxels backward.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region2Backward_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(zIndex==workspace.vectorCols-1)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in90to180 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in90to180 = workspace.vectors[xIndex,yIndex,zIndex+1].in90to180;
						}
					}
			workspace.refreshShiftView();				
		}

		/// <summary>
		/// Shift the Region2 voxels forward.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region2Forward_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=workspace.vectorCols-1; zIndex>=0; zIndex--)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(zIndex==0)
							workspace.vectors[xIndex,yIndex,zIndex].in90to180 = false;
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in90to180 = workspace.vectors[xIndex,yIndex,zIndex-1].in90to180;
						}
					}
			workspace.refreshShiftView();		
		}

		/// <summary>
		/// Shift the Region3 voxels right.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region3Right_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=workspace.vectorCols-1; xIndex>=0; xIndex--)
					{
						if(xIndex==0)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in180to270 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in180to270 = workspace.vectors[xIndex-1,yIndex,zIndex].in180to270;
						}
					}
			workspace.refreshShiftView();					
		}

		/// <summary>
		/// Shift the Region3 voxels left.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region3Left_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(xIndex==workspace.vectorCols-1)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in180to270 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in180to270 = workspace.vectors[xIndex+1,yIndex,zIndex].in180to270;
						}
					}
			workspace.refreshShiftView();		
		}

		/// <summary>
		/// Shift the Region3 voxels backward.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region3Backward_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(zIndex==workspace.vectorCols-1)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in180to270 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in180to270 = workspace.vectors[xIndex,yIndex,zIndex+1].in180to270;
						}
					}
			workspace.refreshShiftView();				
		}

		/// <summary>
		/// Shift the Region3 voxels forward.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region3Forward_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=workspace.vectorCols-1; zIndex>=0; zIndex--)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(zIndex==0)
							workspace.vectors[xIndex,yIndex,zIndex].in180to270 = false;
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in180to270 = workspace.vectors[xIndex,yIndex,zIndex-1].in180to270;
						}
					}
			workspace.refreshShiftView();		
		}

		/// <summary>
		/// Shift the Region4 voxels right.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region4Right_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=workspace.vectorCols-1; xIndex>=0; xIndex--)
					{
						if(xIndex==0)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in270to360 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in270to360 = workspace.vectors[xIndex-1,yIndex,zIndex].in270to360;
						}
					}
			workspace.refreshShiftView();
		}

		/// <summary>
		/// Shift the Region4 voxels left.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region4Left_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(xIndex==workspace.vectorCols-1)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in270to360 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in270to360 = workspace.vectors[xIndex+1,yIndex,zIndex].in270to360;
						}
					}
			workspace.refreshShiftView();
		}

		/// <summary>
		/// Shift the Region4 voxels backward.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region4Backward_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=0; zIndex<workspace.vectorCols; zIndex++)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(zIndex==workspace.vectorCols-1)
						{
							workspace.vectors[xIndex,yIndex,zIndex].in270to360 = false;
						}
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in270to360 = workspace.vectors[xIndex,yIndex,zIndex+1].in270to360;
						}
					}
			workspace.refreshShiftView();
		}

		/// <summary>
		/// Shift the Region4 voxels forward.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Region4Forward_Click(object sender, System.EventArgs e)
		{
			for(int zIndex=workspace.vectorCols-1; zIndex>=0; zIndex--)
				for(int yIndex=0; yIndex<workspace.vectorRows; yIndex++)
					for(int xIndex=0; xIndex<workspace.vectorCols; xIndex++)
					{
						if(zIndex==0)
							workspace.vectors[xIndex,yIndex,zIndex].in270to360 = false;
						else
						{
							workspace.vectors[xIndex,yIndex,zIndex].in270to360 = workspace.vectors[xIndex,yIndex,zIndex-1].in270to360;
						}
					}
			workspace.refreshShiftView();						
		}
		#endregion

		#region Finalize Button Handler
		/// <summary>
		/// Gather all voxels that represent
		/// the total intersection of the 
		/// four regions' data.
		/// Transfer this data to the
		/// workspace.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FinalizeButton_Click(object sender, System.EventArgs e)
		{
			ArrayList finalizedVoxels = new ArrayList(1);
			for(int voxelIndex=0; voxelIndex<workspace.shiftVoxels.Count; voxelIndex++)
			{
				if(((Voxel)workspace.shiftVoxels[voxelIndex]).inAll())
				{
					finalizedVoxels.Add(new Voxel((Voxel)workspace.shiftVoxels[voxelIndex]));
					finalizedVoxels.Capacity++;
				}
			}
			workspace.finalizedVoxels = finalizedVoxels;
			workspace.saveMdl();
			new VoxelView(workspace);
		}
		#endregion
	}
}
